/*****************************************************/
/* Examples Program For "ET-ARM7 BASE LPC2103" Board */
/* Target MCU  : Philips ARM7-LPC2103                */
/*       	   : X-TAL : 19.6608 MHz                 */
/*             : Run Speed 58.9824MHz (With PLL)     */
/* Keil Editor : uVision3 V3.03a                     */
/* Compiler    : Keil CARM V2.50a		             */
/* Create By   : Eakachai Makarn (WWW.ETT.CO.TH)     */
/* Last Update : 17/April/2006                       */
/* Function    : Example Read RTC + Display on UART0 */
/*****************************************************/
// Read/Write Internal RTC of LPC2103
// Display Result on UART0(9600,N,8,1)

#include <LPC2103.H> 	                                	// LPC2103 MPU Register
#include <stdio.h>											// For Used Function printf 

#define MASKSEC 0x3F  										// Second 00..59   00000000:00000000:00xxxxxx
#define MASKMIN 0x3F00										// Minute 00..59   00000000:00xxxxxx:00000000
#define MASKHR  0x1F0000									// Hour 00..23	   000xxxxx:00000000:00000000

/* pototype  section */
void init_serial0 (void); 									// Initil UART-0
int putchar (int ch);  										// Put Char to UART-0
int getchar (void);  										// Get Char From Uart-0

int main(void)
{  
  unsigned char Hour,Minute,Second,Last_Second;				// RTC Buffer Data
  init_serial0();		   									// Initilial UART0 = 9600,N,8,1
  printf("\n\n\nET-ARM7 STAMP LPC2103...TEST RTC\n"); 		// Call prinff Function

  // Initial Internal RTC Function
  CCR &= 0x00;												// Reset All Bit
  CCR |= 0x10; 												// CLKSRC = 1 = Used EXT 32.768 KHz
  CCR |= 0x02; 												// Reset Clock	  (0000 0010)
  CCR &= 0xFD;												// Release Reset  (1111 1101)
  CCR |= 0x01;												// Start RTC Clock	
  CCR  = 0x11;												// Start RTC Clock Used EXT 32.768 KHz

  // Setup Start Time For RTC = 00:00:00
  HOUR = 0x00;
  MIN  = 0x00;
  SEC  = 0x00;
  Last_Second = 0x00;
 
  // Start Test Read RTC and Display on UART0 //
  while(1)
  { 
    do 														// Repeat Get Second until Second Change
	{		
	  Hour   = (CTIME0 & MASKHR)>>16;						// Read Hour
	  Minute = (CTIME0 & MASKMIN)>>8;		 				// Read Minute
	  Second = CTIME0 & MASKSEC;		  					// Read Second
    }
    while(Last_Second == Second);							// Repeat if Second Not Change
	
    Last_Second = Second;									// Update Current Second
          
    //************************************//
    // Display Clock = Hour:Minute:Second //
    //************************************//
    printf("\rReal Time Clock = ");							// Print Message String 
  	printf(" %2d : %2d : %2d",Hour,Minute,Second);	 
  }
}

/******************************/
/* Initial UART0 = 9600,N,8,1 */
/* VPB(pclk) = 29.4912 MHz    */
/******************************/
void init_serial0 (void)  
{
  PINSEL0 &= 0xFFFFFFF0;									// Reset P0.0,P0.1 Pin Config
  PINSEL0 |= 0x00000001;									// Select P0.0 = TxD(UART0)
  PINSEL0 |= 0x00000004;									// Select P0.1 = RxD(UART0)

  U0LCR &= 0xFC;											// Reset Word Select(1:0)
  U0LCR |= 0x03;											// Data Bit = 8 Bit
  U0LCR &= 0xFB;											// Stop Bit = 1 Bit
  U0LCR &= 0xF7;											// Parity = Disable
  U0LCR &= 0xBF;											// Disable Break Control
  U0LCR |= 0x80;											// Enable Programming of Divisor Latches

  // U0DLM:U0DLL = 29.4912MHz / [16 x Baud]
  //             = 29.4912MHz / [16 x 9600]
  //             = 192 = 0x00C0
  U0DLM = 0x00;												// Program Divisor Latch(192) for 9600 Baud
  U0DLL = 0xC0;

  U0LCR &= 0x7F;											// Disable Programming of Divisor Latches

  U0FCR |= 0x01;											// FIF0 Enable
  U0FCR |= 0x02;											// RX FIFO Reset
  U0FCR |= 0x04;											// TX FIFO Reset
  U0FCR &= 0x3F;                      
}

/****************************/
/* Write Character To UART0 */
/****************************/
int putchar (int ch)  
{                  
  if (ch == '\n')  
  {
    while (!(U0LSR & 0x20));  								// Wait TXD Buffer Empty
    U0THR = 0x0D;                          					// Write CR
  }
  while (!(U0LSR & 0x20));									// Wait TXD Buffer Empty
  return (U0THR = ch);										// Write Character
}

/*****************************/
/* Read Character From UART0 */
/*****************************/
int getchar (void)  
{                    
  while (!(U0LSR & 0x01));									// Wait RXD Receive Data Ready
  return (U0RBR);											// Get Receice Data & Return
}





